/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.swing;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.EFrame;
import gnu.jemacs.buffer.EKeymap;
import gnu.jemacs.buffer.EWindow;
import gnu.jemacs.buffer.IgnoreAction;
import gnu.jemacs.buffer.Modeline;
import gnu.jemacs.swing.SwingBuffer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;

public class SwingWindow
extends EWindow
implements FocusListener,
KeyListener,
ChangeListener {
    static Hashtable panemap = new Hashtable();
    JTextPane jtextpane;
    JPanel panel;
    JScrollPane scrollPane;

    public SwingWindow(Buffer buffer) {
        this(buffer, true);
    }

    public SwingWindow(Buffer buffer, boolean bl) {
        super(null);
        this.jtextpane = new JTextPane(((SwingBuffer)buffer).doc);
        panemap.put(this.jtextpane, this);
        if (bl) {
            this.modeline = new Modeline(this, ((SwingBuffer)buffer).modelineDocument);
        }
        this.buffer = buffer;
        this.jtextpane.addFocusListener(this);
        this.jtextpane.addKeyListener(this);
    }

    public JPanel wrap() {
        BorderLayout borderLayout = new BorderLayout();
        JPanel jPanel = new JPanel(borderLayout);
        this.scrollPane = new JScrollPane(this.jtextpane, 22, 31);
        jPanel.add((Component)this.scrollPane, "Center");
        if (this.modeline != null) {
            jPanel.add((Component)this.modeline, "South");
        }
        this.panel = jPanel;
        return jPanel;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.setSelected();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void requestFocus() {
        this.jtextpane.requestFocus();
    }

    public void setBuffer(Buffer buffer) {
        EWindow eWindow;
        if (this.buffer == buffer) {
            return;
        }
        super.setBuffer(buffer);
        this.jtextpane.setDocument(((SwingBuffer)buffer).doc);
        if (this.modeline != null) {
            this.modeline.setDocument(((SwingBuffer)buffer).modelineDocument);
        }
        if ((eWindow = SwingWindow.getSelected()) == this) {
            this.unselect();
            Caret caret = this.jtextpane.getCaret();
            caret.setDot(buffer.getDot());
            this.select(caret);
        }
    }

    void unselect() {
        int n;
        Caret caret = ((SwingBuffer)this.buffer).curPosition;
        if (caret == null) {
            return;
        }
        int n2 = caret.getDot();
        this.buffer.pointMarker.ipos = n = ((SwingBuffer)this.buffer).content.createPos(n2, true);
        ((SwingBuffer)this.buffer).curPosition = null;
        this.jtextpane.getCaret().removeChangeListener(this);
    }

    public void setSelected() {
        EWindow eWindow = SwingWindow.getSelected();
        if (eWindow != null && eWindow.buffer != this.buffer) {
            ((SwingWindow)eWindow).unselect();
        }
        if (this.frame != null) {
            this.frame.selectedWindow = this;
        }
        EFrame.selectedFrame = this.frame;
        Buffer.setCurrent(this.buffer);
        this.select(this.jtextpane.getCaret());
    }

    public int getPoint() {
        return 1 + this.jtextpane.getCaret().getDot();
    }

    public void setDot(int n) {
        this.jtextpane.getCaret().setDot(n);
    }

    public EWindow split(Buffer buffer, int n, boolean bl) {
        EFrame eFrame;
        SwingWindow swingWindow = new SwingWindow(buffer);
        swingWindow.frame = eFrame = this.frame;
        this.linkSibling(swingWindow, bl);
        swingWindow.modeline = new Modeline(swingWindow, ((SwingBuffer)buffer).modelineDocument);
        JPanel jPanel = this.getPanel();
        Dimension dimension = jPanel.getSize();
        Container container = jPanel.getParent();
        container.remove(jPanel);
        JSplitPane jSplitPane = new JSplitPane(bl ? 1 : 0, jPanel, swingWindow.wrap());
        jSplitPane.setDividerSize(2);
        jSplitPane.setDividerLocation((bl ? dimension.width : dimension.height) / 2);
        container.add(jSplitPane);
        container.validate();
        if (this == EWindow.getSelected()) {
            this.requestFocus();
        }
        return swingWindow;
    }

    private void select(Caret caret) {
        ((SwingBuffer)this.buffer).curPosition = caret;
        if (!this.buffer.pointMarker.isPoint()) {
            ((SwingBuffer)this.buffer).content.releasePos(this.buffer.pointMarker.ipos);
        }
        this.buffer.pointMarker.sequence = null;
        caret.addChangeListener(this);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        Caret caret;
        int n2;
        Object object2 = changeEvent.getSource();
        if (object2 instanceof Caret && this.buffer != null && (n2 = (caret = (Caret)object2).getMark()) != (n = caret.getDot())) {
            this.buffer.markMarker.set(this.buffer, n2);
        }
    }

    public static JTextPane getContainedWindow(Container container, boolean bl) {
        while (!(container instanceof JTextPane)) {
            if (container instanceof JScrollPane) {
                container = (Container)((JScrollPane)container).getViewport().getView();
                continue;
            }
            if (container instanceof JFrame) {
                container = ((JFrame)container).getContentPane();
                continue;
            }
            if (container instanceof JSplitPane) {
                JSplitPane jSplitPane = (JSplitPane)container;
                container = (Container)(bl ? jSplitPane.getRightComponent() : jSplitPane.getLeftComponent());
                continue;
            }
            int n = container.getComponentCount();
            if (n == 0) {
                return null;
            }
            container = (Container)container.getComponent(bl ? n - 1 : 0);
        }
        return (JTextPane)container;
    }

    public static SwingWindow getWindow(ActionEvent actionEvent) {
        Component component = (Component)actionEvent.getSource();
        while (!(component instanceof JTextPane)) {
            component = component.getParent();
        }
        return (SwingWindow)panemap.get(component);
    }

    protected void deleteNoValidate() {
        super.deleteNoValidate();
        if (this.modeline != null) {
            this.panel.remove(this.modeline);
        }
        this.panel.remove(this.scrollPane);
        Container container = this.panel.getParent();
        if (container instanceof JSplitPane) {
            JSplitPane jSplitPane = (JSplitPane)container;
            Component component = this.panel == jSplitPane.getLeftComponent() ? jSplitPane.getRightComponent() : jSplitPane.getLeftComponent();
            jSplitPane.remove(this.jtextpane);
            jSplitPane.remove(component);
            Container container2 = jSplitPane.getParent();
            if (container2 instanceof JSplitPane) {
                JSplitPane jSplitPane2 = (JSplitPane)container2;
                if (jSplitPane == jSplitPane2.getLeftComponent()) {
                    jSplitPane2.setLeftComponent(component);
                } else {
                    jSplitPane2.setRightComponent(component);
                }
            } else {
                container2.remove(jSplitPane);
                container2.add(component);
            }
        } else {
            container.remove(this.panel);
        }
        panemap.remove(this.jtextpane);
        this.jtextpane = null;
        this.panel = null;
        this.scrollPane = null;
    }

    public void activateRegion() {
        System.err.println("(activateRegions)");
        Caret caret = this.jtextpane.getCaret();
        caret.setDot(this.buffer.markMarker.getOffset());
        caret.moveDot(this.buffer.getDot());
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this.panel.getSize();
        if (this.modeline != null) {
            dimension = new Dimension(dimension.width, dimension.height - this.modeline.getPreferredSize().height);
        }
        return dimension;
    }

    protected void getCharSize() {
        SwingBuffer cfr_ignored_0 = (SwingBuffer)this.buffer;
        Font font = ((SwingBuffer)this.buffer).doc.getFont(SwingBuffer.defaultStyle);
        FontMetrics fontMetrics = this.jtextpane.getGraphics().getFontMetrics(font);
        this.charHeight = fontMetrics.getHeight();
        this.charWidth = fontMetrics.charWidth('m');
    }

    public int getWidth() {
        return this.jtextpane.getWidth();
    }

    public int getHeight() {
        return this.jtextpane.getWidth();
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.handle(keyEvent, this.toInt(keyEvent, 0));
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.handle(keyEvent, this.toInt(keyEvent, EKeymap.PRESSED));
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.handle(keyEvent, this.toInt(keyEvent, EKeymap.RELEASED));
    }

    protected void handle(KeyEvent keyEvent, int n) {
        Object object2 = this.lookupKey(n);
        this.pushPrefix(n);
        --this.pendingLength;
        if (object2 == null || object2 instanceof IgnoreAction) {
            keyEvent.consume();
            return;
        }
        this.handleCommand(object2);
        keyEvent.consume();
    }

    int toInt(KeyEvent keyEvent, int n) {
        int n2 = keyEvent.getKeyCode();
        n2 = n2 == 0 ? (int)keyEvent.getKeyChar() : (n2 |= (keyEvent.getModifiers() | n) << 16);
        return n2;
    }
}

