/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Expression;
import gnu.expr.Target;
import gnu.kawa.xml.NodeConstructor;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.mapping.CallContext;
import gnu.mapping.Symbol;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class AttributeConstructor
extends NodeConstructor
implements Externalizable {
    String sname;
    Symbol qname;
    static final Method beginAttributeMethod = Compilation.typeConsumer.getDeclaredMethod("beginAttribute", 2);
    static final Method endAttributeMethod = Compilation.typeConsumer.getDeclaredMethod("endAttribute", 0);

    public String getXmlName() {
        return this.sname;
    }

    public Symbol getQName() {
        return this.qname;
    }

    public final String getNamespaceURI() {
        return this.qname.getNamespaceURI();
    }

    public final String getLocalName() {
        return this.qname.getLocalName();
    }

    public final String getPrefix() {
        int n = this.sname.indexOf(58);
        if (n <= 0) {
            return null;
        }
        return this.sname.substring(0, n);
    }

    public static AttributeConstructor make(String string, Symbol symbol) {
        AttributeConstructor attributeConstructor = new AttributeConstructor();
        attributeConstructor.sname = string.intern();
        attributeConstructor.qname = symbol;
        return attributeConstructor;
    }

    public static AttributeConstructor make(String string, String string2, String string3) {
        AttributeConstructor attributeConstructor = new AttributeConstructor();
        attributeConstructor.sname = string.intern();
        attributeConstructor.qname = Symbol.make(string2, string3);
        return attributeConstructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(CallContext callContext) {
        Consumer consumer = callContext.consumer;
        Consumer consumer2 = AttributeConstructor.pushNodeContext(callContext);
        try {
            Object object2;
            consumer2.beginAttribute(this.sname, this.qname);
            String string = Symbol.UNBOUND;
            while ((object2 = callContext.getNextArg(string)) != string) {
                if (object2 instanceof Consumable) {
                    ((Consumable)object2).consume(consumer2);
                    continue;
                }
                consumer2.writeObject(object2);
            }
            consumer2.endAttribute();
        }
        finally {
            AttributeConstructor.popNodeContext(consumer, callContext);
        }
    }

    public void compileToNode(ApplyExp applyExp, Compilation compilation, ConsumerTarget consumerTarget) {
        Variable variable = consumerTarget.getConsumerVariable();
        Expression[] expressionArray = applyExp.getArgs();
        int n = expressionArray.length;
        CodeAttr codeAttr = compilation.getCode();
        codeAttr.emitLoad(variable);
        compilation.compileConstant(this.sname, Target.pushObject);
        compilation.compileConstant(this.qname, Target.pushObject);
        codeAttr.emitInvokeInterface(beginAttributeMethod);
        for (int i = 0; i < n; ++i) {
            AttributeConstructor.compileChild(expressionArray[i], compilation, consumerTarget);
        }
        codeAttr.emitLoad(variable);
        codeAttr.emitInvokeInterface(endAttributeMethod);
    }

    public Type getReturnType(Expression[] expressionArray) {
        return Compilation.typeObject;
    }

    public String toString() {
        return "#<AttributeConstructor " + this.sname + " :: " + this.qname + '>';
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.sname);
        objectOutput.writeObject(this.qname);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.sname = ((String)objectInput.readObject()).intern();
        this.qname = (Symbol)objectInput.readObject();
    }
}

