/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.LambdaExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;

public class CheckedTarget
extends StackTarget {
    LambdaExp proc;
    String procname;
    int argno;
    static ClassType typeClassCastException;
    static ClassType typeWrongType;
    static Method initWrongTypeStringMethod;
    static Method initWrongTypeProcMethod;

    public CheckedTarget(Type type) {
        super(type);
        this.argno = -4;
    }

    public CheckedTarget(Type type, LambdaExp lambdaExp, int n) {
        super(type);
        this.proc = lambdaExp;
        this.procname = lambdaExp.getName();
        this.argno = n;
    }

    public CheckedTarget(Type type, String string, int n) {
        super(type);
        this.procname = string;
        this.argno = n;
    }

    public static Target getInstance(Type type, String string, int n) {
        return type == Type.objectType ? Target.pushObject : new CheckedTarget(type, string, n);
    }

    public static Target getInstance(Type type, LambdaExp lambdaExp, int n) {
        return type == Type.objectType ? Target.pushObject : new CheckedTarget(type, lambdaExp, n);
    }

    public static Target getInstance(Type type) {
        return type == Type.objectType ? Target.pushObject : new CheckedTarget(type);
    }

    private static void initWrongType() {
        if (typeClassCastException == null) {
            typeClassCastException = ClassType.make("java.lang.ClassCastException");
        }
        if (typeWrongType == null) {
            typeWrongType = ClassType.make("gnu.mapping.WrongType");
            Type[] typeArray = new Type[]{typeClassCastException, Compilation.javaStringType, Type.intType, Type.objectType};
            initWrongTypeStringMethod = typeWrongType.addMethod("<init>", 1, typeArray, Type.voidType);
            typeArray = new Type[]{typeClassCastException, Compilation.typeProcedure, Type.intType, Type.objectType};
            initWrongTypeProcMethod = typeWrongType.addMethod("<init>", 1, typeArray, Type.voidType);
        }
    }

    public void compileFromStack(Compilation compilation, Type type) {
        if (!this.compileFromStack0(compilation, type)) {
            CheckedTarget.emitCheckedCoerce(compilation, this.proc, this.procname, this.argno, this.type, null);
        }
    }

    public static void emitCheckedCoerce(Compilation compilation, String string, int n, Type type) {
        CheckedTarget.emitCheckedCoerce(compilation, null, string, n, type, null);
    }

    public static void emitCheckedCoerce(Compilation compilation, LambdaExp lambdaExp, int n, Type type) {
        CheckedTarget.emitCheckedCoerce(compilation, lambdaExp, lambdaExp.getName(), n, type, null);
    }

    public static void emitCheckedCoerce(Compilation compilation, LambdaExp lambdaExp, int n, Type type, Variable variable) {
        CheckedTarget.emitCheckedCoerce(compilation, lambdaExp, lambdaExp.getName(), n, type, variable);
    }

    static void emitCheckedCoerce(Compilation compilation, LambdaExp lambdaExp, String string, int n, Type type, Variable variable) {
        int n2;
        Scope scope;
        CodeAttr codeAttr = compilation.getCode();
        boolean bl = codeAttr.isInTry();
        CheckedTarget.initWrongType();
        Label label = new Label(codeAttr);
        if (variable == null && type != Type.toStringType) {
            scope = codeAttr.pushScope();
            variable = codeAttr.addLocal(Type.objectType);
            codeAttr.emitDup(1);
            codeAttr.emitStore(variable);
        } else {
            scope = null;
        }
        int n3 = codeAttr.getPC();
        label.define(codeAttr);
        CheckedTarget.emitCoerceFromObject(type, compilation);
        int n4 = codeAttr.getPC();
        if (n4 == n3 || type == Type.toStringType) {
            if (scope != null) {
                codeAttr.popScope();
            }
            return;
        }
        Label label2 = new Label(codeAttr);
        label2.define(codeAttr);
        Label label3 = new Label(codeAttr);
        label3.setTypes(codeAttr);
        if (bl) {
            codeAttr.emitGoto(label3);
        }
        int n5 = 0;
        codeAttr.setUnreachable();
        if (!bl) {
            n5 = codeAttr.beginFragment(label3);
        }
        codeAttr.addHandler(label, label2, typeClassCastException);
        boolean bl2 = false;
        if (lambdaExp != null && lambdaExp.isClassGenerated() && !compilation.method.getStaticFlag() && compilation.method.getDeclaringClass() == lambdaExp.getCompiledClassType(compilation)) {
            bl2 = true;
        }
        if ((n2 = compilation.getLineNumber()) > 0) {
            codeAttr.putLineNumber(n2);
        }
        codeAttr.emitNew(typeWrongType);
        codeAttr.emitDupX();
        codeAttr.emitSwap();
        if (bl2) {
            codeAttr.emitPushThis();
        } else {
            codeAttr.emitPushString(string == null && n != -4 ? "lambda" : string);
        }
        codeAttr.emitPushInt(n);
        codeAttr.emitLoad(variable);
        codeAttr.emitInvokeSpecial(bl2 ? initWrongTypeProcMethod : initWrongTypeStringMethod);
        if (scope != null) {
            codeAttr.popScope();
        }
        codeAttr.emitThrow();
        if (bl) {
            label3.define(codeAttr);
        } else {
            codeAttr.endFragment(n5);
        }
    }
}

