/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.PrimProcedure;
import gnu.kawa.functions.ArithOp;
import gnu.kawa.functions.Arithmetic;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.mapping.Procedure;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RatNum;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AddOp
extends ArithOp {
    int plusOrMinus = 1;
    public static final AddOp $Pl = new AddOp("+", 1);
    public static final AddOp $Mn = new AddOp("-", -1);

    public AddOp(String string, int n) {
        super(string);
        this.plusOrMinus = n;
    }

    public static Object apply2(int n, Object object2, Object object3) {
        int n2;
        int n3 = Arithmetic.classifyValue(object2);
        int n4 = n3 < (n2 = Arithmetic.classifyValue(object3)) ? n2 : n3;
        switch (n4) {
            case 1: {
                int n5 = Arithmetic.asInt(object2);
                int n6 = Arithmetic.asInt(object3);
                return new Integer(n > 0 ? n5 + n6 : n5 - n6);
            }
            case 2: {
                long l = Arithmetic.asLong(object2);
                long l2 = Arithmetic.asLong(object3);
                return new Long(n > 0 ? l + l2 : l - l2);
            }
            case 3: {
                BigInteger bigInteger = Arithmetic.asBigInteger(object2);
                BigInteger bigInteger2 = Arithmetic.asBigInteger(object3);
                return n > 0 ? bigInteger.add(bigInteger2) : bigInteger.subtract(bigInteger2);
            }
            case 4: {
                return IntNum.add(Arithmetic.asIntNum(object2), Arithmetic.asIntNum(object3), n);
            }
            case 5: {
                BigDecimal bigDecimal = Arithmetic.asBigDecimal(object2);
                BigDecimal bigDecimal2 = Arithmetic.asBigDecimal(object3);
                return n > 0 ? bigDecimal.add(bigDecimal2) : bigDecimal.subtract(bigDecimal2);
            }
            case 6: {
                return RatNum.add(Arithmetic.asRatNum(object2), Arithmetic.asRatNum(object3), n);
            }
            case 7: {
                float f = Arithmetic.asFloat(object2);
                float f2 = Arithmetic.asFloat(object3);
                return new Float(n > 0 ? f + f2 : f - f2);
            }
            case 8: {
                double d = Arithmetic.asDouble(object2);
                double d2 = Arithmetic.asDouble(object3);
                return new Double(n > 0 ? d + d2 : d - d2);
            }
            case 9: {
                double d = Arithmetic.asDouble(object2);
                double d3 = Arithmetic.asDouble(object3);
                return new DFloNum(n > 0 ? d + d3 : d - d3);
            }
        }
        Numeric numeric = Arithmetic.asNumeric(object2);
        Numeric numeric2 = Arithmetic.asNumeric(object3);
        return numeric.add(numeric2, n);
    }

    public static Object $Pl(Object object2, Object object3) {
        return AddOp.apply2(1, object2, object3);
    }

    public static Object $Mn(Object object2, Object object3) {
        return AddOp.apply2(-1, object2, object3);
    }

    public static Object $Mn(Object object2) {
        int n = Arithmetic.classifyValue(object2);
        switch (n) {
            case 1: {
                return new Integer(-Arithmetic.asInt(object2));
            }
            case 2: {
                return new Long(-Arithmetic.asLong(object2));
            }
            case 3: {
                return Arithmetic.asBigInteger(object2).negate();
            }
            case 4: {
                return IntNum.neg(Arithmetic.asIntNum(object2));
            }
            case 5: {
                return Arithmetic.asBigDecimal(object2).negate();
            }
            case 6: {
                return RatNum.neg(Arithmetic.asRatNum(object2));
            }
            case 7: {
                return new Float(-Arithmetic.asFloat(object2));
            }
            case 8: {
                return new Double(-Arithmetic.asDouble(object2));
            }
            case 9: {
                return new DFloNum(-Arithmetic.asDouble(object2));
            }
        }
        return Arithmetic.asNumeric(object2).neg();
    }

    public static Object $Pl$V(Object object2, Object object3, Object object4, Object[] objectArray) {
        return AddOp.applyN(1, AddOp.apply2(1, AddOp.apply2(1, object2, object3), object4), objectArray);
    }

    public static Object $Mn$V(Object object2, Object object3, Object object4, Object[] objectArray) {
        return AddOp.applyN(-1, AddOp.apply2(-1, AddOp.apply2(-1, object2, object3), object4), objectArray);
    }

    public static Object applyN(int n, Object[] objectArray) {
        int n2 = objectArray.length;
        if (n2 == 0) {
            return IntNum.zero();
        }
        Object object2 = objectArray[0];
        if (n2 == 1 && n < 0) {
            return AddOp.$Mn(object2);
        }
        for (int i = 1; i < n2; ++i) {
            object2 = AddOp.apply2(n, object2, objectArray[i]);
        }
        return object2;
    }

    public static Object applyN(int n, Object object2, Object[] objectArray) {
        int n2 = objectArray.length;
        Object object3 = object2;
        for (int i = 0; i < n2; ++i) {
            object3 = AddOp.apply2(n, object3, objectArray[i]);
        }
        return object3;
    }

    public Object applyN(Object[] objectArray) {
        return AddOp.applyN(this.plusOrMinus, objectArray);
    }

    public static Expression pairwise(Procedure procedure, Expression expression, Expression[] expressionArray, InlineCalls inlineCalls) {
        int n = expressionArray.length;
        Expression expression2 = expressionArray[0];
        for (int i = 1; i < n; ++i) {
            Expression[] expressionArray2 = new Expression[]{expression2, expressionArray[i]};
            ApplyExp applyExp = new ApplyExp(expression, expressionArray2);
            expression2 = procedure instanceof CanInline ? ((CanInline)((Object)procedure)).inline(applyExp, inlineCalls, true) : applyExp;
        }
        return expression2;
    }

    public Expression inline(ApplyExp applyExp, InlineCalls inlineCalls, boolean bl) {
        Type type;
        applyExp.walkArgs(inlineCalls, bl);
        if (!inlineCalls.getCompilation().mustCompile) {
            return applyExp;
        }
        Expression expression = applyExp.inlineIfConstant((Procedure)this, inlineCalls);
        if (expression != applyExp) {
            return expression;
        }
        Expression[] expressionArray = applyExp.getArgs();
        if (expressionArray.length > 2) {
            return AddOp.pairwise(this, applyExp.getFunction(), expressionArray, inlineCalls);
        }
        if (expressionArray.length == 1 && this.plusOrMinus < 0 && (type = expressionArray[0].getType()) instanceof PrimType) {
            char c = type.getSignature().charAt(0);
            LangPrimType langPrimType = null;
            int n = 0;
            if (c != 'V' && c != 'Z' && c != 'C') {
                if (c == 'D') {
                    n = 119;
                    langPrimType = LangPrimType.doubleType;
                } else if (c == 'F') {
                    n = 118;
                    langPrimType = LangPrimType.floatType;
                } else if (c == 'J') {
                    n = 117;
                    langPrimType = LangPrimType.longType;
                } else {
                    n = 116;
                    langPrimType = LangPrimType.intType;
                }
            }
            if (langPrimType != null) {
                PrimProcedure primProcedure = PrimProcedure.makeBuiltinUnary(n, langPrimType);
                return new ApplyExp(primProcedure, expressionArray);
            }
        }
        if (expressionArray.length == 2) {
            return AddOp.primInline(this.primitiveOpcode(), applyExp);
        }
        return applyExp;
    }

    public int primitiveOpcode() {
        return this.plusOrMinus > 0 ? 96 : 100;
    }

    public static Expression primInline(int n, ApplyExp applyExp) {
        Expression[] expressionArray = applyExp.getArgs();
        if (expressionArray.length == 2) {
            Type type = expressionArray[0].getType();
            Type type2 = expressionArray[1].getType();
            if (type instanceof PrimType && type2 instanceof PrimType) {
                char c = type.getSignature().charAt(0);
                char c2 = type2.getSignature().charAt(0);
                LangPrimType langPrimType = null;
                if (c != 'V' && c != 'Z' && c != 'C' && c2 != 'V' && c2 != 'Z' && c2 != 'C') {
                    if (c == 'D' || c2 == 'D') {
                        n += 3;
                        langPrimType = LangPrimType.doubleType;
                    } else if (c == 'F' || c2 == 'F') {
                        n += 2;
                        langPrimType = LangPrimType.floatType;
                    } else if (c == 'J' || c2 == 'J') {
                        ++n;
                        langPrimType = LangPrimType.longType;
                    } else {
                        langPrimType = LangPrimType.intType;
                    }
                }
                if (langPrimType != null) {
                    PrimProcedure primProcedure = PrimProcedure.makeBuiltinBinary(n, langPrimType);
                    return new ApplyExp(primProcedure, expressionArray);
                }
            }
        }
        return applyExp;
    }
}

