/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.swingviews;

import gnu.kawa.models.Box;
import gnu.kawa.models.Button;
import gnu.kawa.models.Display;
import gnu.kawa.models.DrawImage;
import gnu.kawa.models.Label;
import gnu.kawa.models.Model;
import gnu.kawa.models.Paintable;
import gnu.kawa.models.Spacer;
import gnu.kawa.models.Text;
import gnu.kawa.models.Window;
import gnu.kawa.swingviews.ComponentModel;
import gnu.kawa.swingviews.ProcActionListener;
import gnu.kawa.swingviews.SwingBox;
import gnu.kawa.swingviews.SwingButton;
import gnu.kawa.swingviews.SwingContent;
import gnu.kawa.swingviews.SwingFrame;
import gnu.kawa.swingviews.SwingLabel;
import gnu.kawa.swingviews.SwingPaintable;
import gnu.mapping.Procedure;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.util.WeakHashMap;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class SwingDisplay
extends Display {
    static final SwingDisplay instance = new SwingDisplay();
    private static WeakHashMap documents = null;

    public static Display getInstance() {
        return instance;
    }

    public Window makeWindow() {
        SwingFrame swingFrame = new SwingFrame(null, null, null);
        swingFrame.display = this;
        return swingFrame;
    }

    public void addButton(Button button, Object object2) {
        this.addView(new SwingButton(button), object2);
    }

    public void addLabel(Label label, Object object2) {
        this.addView(new SwingLabel(label), object2);
    }

    public void addImage(DrawImage drawImage, Object object2) {
        this.addView(new JLabel(new ImageIcon(drawImage.getImage())), object2);
    }

    public void addText(Text text, Object object2) {
        this.addView(new JTextField(SwingDisplay.getSwingDocument(text), text.getText(), 50), object2);
    }

    static synchronized Document getSwingDocument(Text text) {
        Object v;
        if (documents == null) {
            documents = new WeakHashMap();
        }
        if ((v = documents.get(text)) != null) {
            return (Document)v;
        }
        PlainDocument plainDocument = new PlainDocument(new SwingContent(text.buffer));
        documents.put(text, plainDocument);
        return plainDocument;
    }

    public void addBox(Box box, Object object2) {
        this.addView(new SwingBox(box, this), object2);
    }

    public void addSpacer(Spacer spacer, Object object2) {
        this.addView(new Box.Filler(spacer.getMinimumSize(), spacer.getPreferredSize(), spacer.getMaximumSize()), object2);
    }

    public void addView(Object object2, Object object3) {
        ((Container)object3).add((Component)object2);
    }

    public static ActionListener makeActionListener(Object object2) {
        if (object2 instanceof ActionListener) {
            return (ActionListener)object2;
        }
        return new ProcActionListener((Procedure)object2);
    }

    public Model coerceToModel(Object object2) {
        if (object2 instanceof Component) {
            return new ComponentModel((Component)object2);
        }
        if (object2 instanceof Paintable) {
            return new ComponentModel(new SwingPaintable((Paintable)object2));
        }
        return super.coerceToModel(object2);
    }
}

