/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHashTable<Entry, K, V> {
    protected Entry[] table;
    protected int mask;
    protected int num_bindings;

    protected abstract int getEntryHashCode(Entry var1);

    protected abstract Entry getEntryNext(Entry var1);

    protected abstract void setEntryNext(Entry var1, Entry var2);

    protected abstract K getEntryKey(Entry var1);

    protected abstract V getEntryValue(Entry var1);

    protected abstract void setEntryValue(Entry var1, V var2);

    protected abstract Entry[] allocEntries(int var1);

    public AbstractHashTable(int n) {
        int n2 = 4;
        while (n > 1 << n2) {
            ++n2;
        }
        n = 1 << n2;
        this.table = this.allocEntries(n);
        this.mask = n - 1;
    }

    protected abstract Entry makeEntry(K var1, int var2, V var3);

    public int hash(K k) {
        return k == null ? 0 : k.hashCode();
    }

    protected int hashToIndex(int n) {
        n ^= n >>> 15;
        return n & this.mask;
    }

    protected boolean matches(K k, int n, Entry Entry2) {
        return this.getEntryHashCode(Entry2) == n && this.matches(this.getEntryKey(Entry2), k);
    }

    protected boolean matches(K k, K k2) {
        return k == k2 || k != null && k.equals(k2);
    }

    public V get(K k) {
        return this.get(k, null);
    }

    public Entry getNode(K k) {
        int n = this.hash(k);
        int n2 = this.hashToIndex(n);
        Entry Entry2 = this.table[n2];
        while (Entry2 != null) {
            if (this.matches(k, n, Entry2)) {
                return Entry2;
            }
            Entry2 = this.getEntryNext(Entry2);
        }
        return null;
    }

    public V get(K k, V v) {
        Entry Entry2 = this.getNode(k);
        return Entry2 == null ? v : this.getEntryValue(Entry2);
    }

    protected void rehash() {
        Entry[] EntryArray = this.table;
        int n = EntryArray.length;
        int n2 = 2 * n;
        Entry[] EntryArray2 = this.allocEntries(n2);
        int n3 = n2 - 1;
        this.table = EntryArray2;
        this.mask = n3;
        int n4 = n;
        while (--n4 >= 0) {
            Entry Entry2;
            Entry Entry3;
            Entry Entry4 = EntryArray[n4];
            if (Entry4 != null && this.getEntryNext(Entry4) != null) {
                Entry3 = null;
                do {
                    Entry2 = Entry4;
                    Entry4 = this.getEntryNext(Entry2);
                    this.setEntryNext(Entry2, Entry3);
                    Entry3 = Entry2;
                } while (Entry4 != null);
                Entry4 = Entry3;
            }
            Entry3 = Entry4;
            while (Entry3 != null) {
                Entry2 = this.getEntryNext(Entry3);
                int n5 = this.getEntryHashCode(Entry3);
                int n6 = this.hashToIndex(n5);
                Entry Entry5 = EntryArray2[n6];
                this.setEntryNext(Entry3, Entry5);
                EntryArray2[n6] = Entry3;
                Entry3 = Entry2;
            }
        }
    }

    public V put(K k, V v) {
        return this.put(k, this.hash(k), v);
    }

    public V put(K k, int n, V v) {
        Entry Entry2;
        int n2 = this.hashToIndex(n);
        Entry Entry3 = Entry2 = this.table[n2];
        while (true) {
            if (Entry3 == null) {
                if (++this.num_bindings >= this.table.length) {
                    this.rehash();
                    n2 = this.hashToIndex(n);
                    Entry2 = this.table[n2];
                }
                Entry3 = this.makeEntry(k, n, v);
                this.setEntryNext(Entry3, Entry2);
                this.table[n2] = Entry3;
                return null;
            }
            if (this.matches(k, n, Entry3)) {
                V v2 = this.getEntryValue(Entry3);
                this.setEntryValue(Entry3, v);
                return v2;
            }
            Entry3 = this.getEntryNext(Entry3);
        }
    }

    public V remove(K k) {
        int n = this.hash(k);
        int n2 = this.hashToIndex(n);
        Entry Entry2 = null;
        Entry Entry3 = this.table[n2];
        while (Entry3 != null) {
            Entry Entry4 = this.getEntryNext(Entry3);
            if (this.matches(k, n, Entry3)) {
                if (Entry2 == null) {
                    this.table[n2] = Entry4;
                } else {
                    this.setEntryNext(Entry2, Entry4);
                }
                --this.num_bindings;
                return this.getEntryValue(Entry3);
            }
            Entry2 = Entry3;
            Entry3 = Entry4;
        }
        return null;
    }

    public void clear() {
        Entry[] EntryArray = this.table;
        int n = EntryArray.length;
        while (--n >= 0) {
            this.setEntryNext(EntryArray[n], null);
        }
        this.num_bindings = 0;
    }

    public int size() {
        return this.num_bindings;
    }
}

