/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.text.Path;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class TtyInPort
extends InPort {
    protected OutPort tie;
    protected Procedure prompter;
    protected boolean promptEmitted;

    public Procedure getPrompter() {
        return this.prompter;
    }

    public void setPrompter(Procedure procedure) {
        this.prompter = procedure;
    }

    public TtyInPort(InputStream inputStream, Path path, OutPort outPort) {
        super(inputStream, path);
        this.setConvertCR(true);
        this.tie = outPort;
    }

    public TtyInPort(Reader reader, Path path, OutPort outPort) {
        super(reader, path);
        this.setConvertCR(true);
        this.tie = outPort;
    }

    public int fill(int n) throws IOException {
        int n2 = this.in.read(this.buffer, this.pos, n);
        if (this.tie != null && n2 > 0) {
            this.tie.echo(this.buffer, this.pos, n2);
        }
        return n2;
    }

    public void emitPrompt(String string) throws IOException {
        this.tie.print(string);
        this.tie.flush();
        this.tie.clearBuffer();
    }

    public void lineStart(boolean bl) throws IOException {
        if (!bl) {
            if (this.tie != null) {
                this.tie.freshLine();
            }
            if (this.prompter != null) {
                try {
                    String string;
                    Object object2 = this.prompter.apply1(this);
                    if (object2 != null && (string = object2.toString()) != null && string.length() > 0) {
                        this.emitPrompt(string);
                        this.promptEmitted = true;
                    }
                }
                catch (Throwable throwable) {
                    throw new IOException("Error when evaluating prompt:" + throwable);
                }
            }
        }
    }

    public int read() throws IOException {
        int n;
        if (this.tie != null) {
            this.tie.flush();
        }
        if ((n = super.read()) < 0 && this.promptEmitted & this.tie != null) {
            this.tie.println();
        }
        this.promptEmitted = false;
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        if (this.tie != null) {
            this.tie.flush();
        }
        if ((n3 = super.read(cArray, n, n2)) < 0 && this.promptEmitted & this.tie != null) {
            this.tie.println();
        }
        this.promptEmitted = false;
        return n3;
    }
}

