/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.util;

import gnu.kawa.xml.KNode;
import gnu.kawa.xml.UntypedAtomic;
import gnu.kawa.xml.XIntegerType;
import gnu.lists.AbstractSequence;
import gnu.lists.Consumer;
import gnu.mapping.CallContext;
import gnu.mapping.Values;
import gnu.mapping.WrongType;
import gnu.math.IntNum;
import gnu.text.Path;
import gnu.text.URIPath;
import gnu.xml.TextUtils;
import gnu.xquery.util.NamedCollator;
import gnu.xquery.util.NumberValue;
import gnu.xquery.util.SequenceUtils;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static String ERROR_VALUE = "<error>";

    static String coerceToString(Object object2, String string, int n, String string2) {
        if (object2 instanceof KNode) {
            object2 = KNode.atomicValue(object2);
        }
        if ((object2 == Values.empty || object2 == null) && string2 != ERROR_VALUE) {
            return string2;
        }
        if (object2 instanceof UntypedAtomic || object2 instanceof CharSequence || object2 instanceof URI || object2 instanceof Path) {
            return object2.toString();
        }
        throw new WrongType(string, n, object2, string2 == ERROR_VALUE ? "xs:string" : "xs:string?");
    }

    public static Object lowerCase(Object object2) {
        return StringUtils.coerceToString(object2, "lower-case", 1, "").toLowerCase();
    }

    public static Object upperCase(Object object2) {
        return StringUtils.coerceToString(object2, "upper-case", 1, "").toUpperCase();
    }

    static double asDouble(Object object2) {
        if (!(object2 instanceof Number)) {
            object2 = NumberValue.numberValue(object2);
        }
        return ((Number)object2).doubleValue();
    }

    public static Object substring(Object object2, Object object3) {
        double d = StringUtils.asDouble(object3);
        if (Double.isNaN(d)) {
            return "";
        }
        int n = (int)(d - 0.5);
        if (n < 0) {
            n = 0;
        }
        String string = StringUtils.coerceToString(object2, "substring", 1, "");
        int n2 = string.length();
        int n3 = 0;
        while (--n >= 0) {
            char c;
            if (n3 >= n2) {
                return "";
            }
            if ((c = string.charAt(n3++)) < '\ud800' || c >= '\udc00' || n3 >= n2) continue;
            ++n3;
        }
        return string.substring(n3);
    }

    public static Object substring(Object object2, Object object3, Object object4) {
        char c;
        String string = StringUtils.coerceToString(object2, "substring", 1, "");
        int n = string.length();
        double d = Math.floor(StringUtils.asDouble(object3) - 0.5);
        double d2 = d + Math.floor(StringUtils.asDouble(object4) + 0.5);
        if (d <= 0.0) {
            d = 0.0;
        }
        if (d2 > (double)n) {
            d2 = n;
        }
        if (d2 <= d) {
            return "";
        }
        int n2 = (int)d;
        int n3 = (int)d2 - n2;
        int n4 = 0;
        while (--n2 >= 0) {
            if (n4 >= n) {
                return "";
            }
            if ((c = string.charAt(n4++)) < '\ud800' || c >= '\udc00' || n4 >= n) continue;
            ++n4;
        }
        n2 = n4;
        while (--n3 >= 0) {
            if (n4 >= n) {
                return "";
            }
            if ((c = string.charAt(n4++)) < '\ud800' || c >= '\udc00' || n4 >= n) continue;
            ++n4;
        }
        n3 = n4;
        return string.substring(n2, n3);
    }

    public static Object stringLength(Object object2) {
        String string = StringUtils.coerceToString(object2, "string-length", 1, "");
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c;
            if ((c = string.charAt(n3++)) >= '\ud800' && c < '\udc00' && n3 < n) {
                ++n3;
            }
            ++n2;
        }
        return IntNum.make(n2);
    }

    public static Object substringBefore(Object object2, Object object3) {
        String string = StringUtils.coerceToString(object2, "substring-before", 1, "");
        String string2 = StringUtils.coerceToString(object3, "substring-before", 2, "");
        int n = string2.length();
        if (n == 0) {
            return "";
        }
        int n2 = string.indexOf(string2);
        return n2 >= 0 ? string.substring(0, n2) : "";
    }

    public static Object substringAfter(Object object2, Object object3) {
        String string = StringUtils.coerceToString(object2, "substring-after", 1, "");
        String string2 = StringUtils.coerceToString(object3, "substring-after", 2, "");
        int n = string2.length();
        if (n == 0) {
            return string;
        }
        int n2 = string.indexOf(string2);
        return n2 >= 0 ? string.substring(n2 + n) : "";
    }

    public static Object translate(Object object2, Object object3, Object object4) {
        String string = StringUtils.coerceToString(object2, "translate", 1, "");
        if (!((object3 = KNode.atomicValue(object3)) instanceof UntypedAtomic) && !(object3 instanceof String)) {
            throw new WrongType("translate", 2, object2, "xs:string");
        }
        String string2 = object3.toString();
        int n = string2.length();
        if (!((object4 = KNode.atomicValue(object4)) instanceof UntypedAtomic) && !(object4 instanceof String)) {
            throw new WrongType("translate", 3, object2, "xs:string");
        }
        String string3 = object4.toString();
        if (n == 0) {
            return string;
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = string3.length();
        int n4 = 0;
        block0: while (n4 < n2) {
            char c = string.charAt(n4++);
            char c2 = '\u0000';
            if (c >= '\ud800' && c < '\udc00' && n4 < n2) {
                c2 = string.charAt(n4++);
            }
            int n5 = 0;
            int n6 = 0;
            block1: while (n6 < n) {
                char c3 = string2.charAt(n6++);
                char c4 = '\u0000';
                if (c3 >= '\ud800' && c3 < '\udc00' && n6 < n) {
                    c4 = string2.charAt(n6++);
                }
                if (c3 == c && c4 == c2) {
                    int n7 = 0;
                    while (n7 < n3) {
                        char c5 = string3.charAt(n7++);
                        char c6 = '\u0000';
                        if (c5 >= '\ud800' && c5 < '\udc00' && n7 < n3) {
                            c6 = string3.charAt(n7++);
                        }
                        if (n5 == 0) {
                            c = c5;
                            c2 = c6;
                            break block1;
                        }
                        --n5;
                    }
                    continue block0;
                }
                ++n5;
            }
            stringBuffer.append(c);
            if (c2 == '\u0000') continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static Object stringPad(Object object2, Object object3) {
        int n = ((Number)NumberValue.numberValue(object3)).intValue();
        if (n <= 0) {
            if (n == 0) {
                return "";
            }
            throw new IndexOutOfBoundsException("Invalid string-pad count");
        }
        String string = StringUtils.coerceToString(object2, "string-pad", 1, "");
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * n2);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static Object contains(Object object2, Object object3) {
        String string;
        String string2 = StringUtils.coerceToString(object2, "contains", 1, "");
        return string2.indexOf(string = StringUtils.coerceToString(object3, "contains", 2, "")) < 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public static Object startsWith(Object object2, Object object3) {
        String string;
        String string2 = StringUtils.coerceToString(object2, "starts-with", 1, "");
        return string2.startsWith(string = StringUtils.coerceToString(object3, "starts-with", 2, "")) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object endsWith(Object object2, Object object3) {
        String string;
        String string2 = StringUtils.coerceToString(object2, "ends-with", 1, "");
        return string2.endsWith(string = StringUtils.coerceToString(object3, "ends-with", 2, "")) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object stringJoin(Object object2, Object object3) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = StringUtils.coerceToString(object3, "string-join", 2, ERROR_VALUE);
        int n = string.length();
        int n2 = 0;
        boolean bl = false;
        while ((n2 = Values.nextIndex(object2, n2)) >= 0) {
            Object object4 = Values.nextValue(object2, n2 - 1);
            if (object4 == Values.empty) continue;
            if (bl && n > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(TextUtils.stringValue(object4));
            bl = true;
        }
        return stringBuffer.toString();
    }

    public static String concat$V(Object object2, Object object3, Object[] objectArray) {
        object2 = SequenceUtils.coerceToZeroOrOne(object2, "concat", 1);
        String string = TextUtils.stringValue(object2);
        object3 = SequenceUtils.coerceToZeroOrOne(object3, "concat", 2);
        String string2 = TextUtils.stringValue(object3);
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(string2);
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object object4 = SequenceUtils.coerceToZeroOrOne(objectArray[i], "concat", i + 2);
            stringBuilder.append(TextUtils.stringValue(object4));
        }
        return stringBuilder.toString();
    }

    public static Object compare(Object object2, Object object3, NamedCollator namedCollator) {
        int n;
        if (object2 == Values.empty || object2 == null || object3 == Values.empty || object3 == null) {
            return Values.empty;
        }
        if (namedCollator == null) {
            namedCollator = NamedCollator.codepointCollation;
        }
        return (n = namedCollator.compare(object2.toString(), object3.toString())) < 0 ? IntNum.minusOne() : (n > 0 ? IntNum.one() : IntNum.zero());
    }

    public static void stringToCodepoints$X(Object object2, CallContext callContext) {
        String string = StringUtils.coerceToString(object2, "string-to-codepoints", 1, "");
        int n = string.length();
        Consumer consumer = callContext.consumer;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) >= 55296 && n3 < 56320 && n2 < n) {
                n3 = (n3 - 55296) * 1024 + (string.charAt(n2++) - 56320) + 65536;
            }
            consumer.writeInt(n3);
        }
    }

    private static void appendCodepoint(Object object2, StringBuffer stringBuffer) {
        IntNum intNum = (IntNum)XIntegerType.integerType.cast(object2);
        int n = intNum.intValue();
        if (n <= 0 || n > 55295 && (n < 57344 || n > 65533 && n < 65536 || n > 0x10FFFF)) {
            throw new IllegalArgumentException("codepoints-to-string: " + n + " is not a valid XML character [FOCH0001]");
        }
        if (n >= 65536) {
            stringBuffer.append((char)((n - 65536 >> 10) + 55296));
            n = (n & 0x3FF) + 56320;
        }
        stringBuffer.append((char)n);
    }

    public static String codepointsToString(Object object2) {
        if (object2 == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (object2 instanceof Values) {
            Values values = (Values)object2;
            int n = values.startPos();
            while ((n = values.nextPos(n)) != 0) {
                StringUtils.appendCodepoint(values.getPosPrevious(n), stringBuffer);
            }
        } else {
            StringUtils.appendCodepoint(object2, stringBuffer);
        }
        return stringBuffer.toString();
    }

    public static String encodeForUri(Object object2) {
        String string = StringUtils.coerceToString(object2, "encode-for-uri", 1, "");
        return URIPath.encodeForUri(string, 'U');
    }

    public static String iriToUri(Object object2) {
        String string = StringUtils.coerceToString(object2, "iri-to-uru", 1, "");
        return URIPath.encodeForUri(string, 'I');
    }

    public static String escapeHtmlUri(Object object2) {
        String string = StringUtils.coerceToString(object2, "escape-html-uri", 1, "");
        return URIPath.encodeForUri(string, 'H');
    }

    public static String normalizeSpace(Object object2) {
        String string = StringUtils.coerceToString(object2, "normalize-space", 1, "");
        int n = string.length();
        StringBuffer stringBuffer = null;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                if (stringBuffer == null && n2 == 0 && i > 0) {
                    stringBuffer = new StringBuffer(string.substring(0, i));
                }
                ++n2;
                continue;
            }
            if (n2 > 0) {
                if (stringBuffer != null) {
                    stringBuffer.append(' ');
                } else if (n2 > 1 || i == 1 || string.charAt(i - 1) != ' ') {
                    stringBuffer = new StringBuffer();
                }
                n2 = 0;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        return stringBuffer != null ? stringBuffer.toString() : (n2 > 0 ? "" : string);
    }

    public static Pattern makePattern(String string, String string2) {
        int n;
        int n2 = 0;
        int n3 = string2.length();
        block6: while (--n3 >= 0) {
            n = string2.charAt(n3);
            switch (n) {
                case 105: {
                    n2 |= 0x42;
                    continue block6;
                }
                case 115: {
                    n2 |= 0x20;
                    continue block6;
                }
                case 120: {
                    StringBuffer stringBuffer = new StringBuffer();
                    int c = string.length();
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < c) {
                        char c2;
                        if ((c2 = string.charAt(n5++)) == '\\' && n5 < c) {
                            stringBuffer.append(c2);
                            c2 = string.charAt(n5++);
                        } else if (c2 == '[') {
                            ++n4;
                        } else if (c2 == ']') {
                            --n4;
                        } else if (n4 == 0 && Character.isWhitespace(c2)) continue;
                        stringBuffer.append(c2);
                    }
                    string = stringBuffer.toString();
                    continue block6;
                }
                case 109: {
                    n2 |= 8;
                    continue block6;
                }
            }
            throw new IllegalArgumentException("unknown 'replace' flag");
        }
        if (string.indexOf("{Is") >= 0) {
            StringBuffer stringBuffer = new StringBuffer();
            n = string.length();
            int n5 = 0;
            while (n5 < n) {
                char c;
                if ((c = string.charAt(n5++)) == '\\' && n5 + 4 < n) {
                    stringBuffer.append(c);
                    c = string.charAt(n5++);
                    stringBuffer.append(c);
                    if (c != 'p' && c != 'P' || string.charAt(n5) != '{' || string.charAt(n5 + 1) != 'I' || string.charAt(n5 + 2) != 's') continue;
                    stringBuffer.append('{');
                    stringBuffer.append('I');
                    stringBuffer.append('n');
                    n5 += 3;
                    continue;
                }
                stringBuffer.append(c);
            }
            string = stringBuffer.toString();
        }
        return Pattern.compile(string, n2);
    }

    public static boolean matches(Object object2, String string) {
        return StringUtils.matches(object2, string, "");
    }

    public static boolean matches(Object object2, String string, String string2) {
        String string3 = StringUtils.coerceToString(object2, "matches", 1, "");
        return StringUtils.makePattern(string, string2).matcher(string3).find();
    }

    public static String replace(Object object2, String string, String string2) {
        return StringUtils.replace(object2, string, string2, "");
    }

    public static String replace(Object object2, String string, String string2, String string3) {
        String string4 = StringUtils.coerceToString(object2, "replace", 1, "");
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = string2.charAt(n2++)) != '\\' || n2 < c && ((c = string2.charAt(n2++)) == '\\' || c == '$')) continue;
            throw new IllegalArgumentException("invalid replacement string [FORX0004]");
        }
        return StringUtils.makePattern(string, string3).matcher(string4).replaceAll(string2);
    }

    public static void tokenize$X(Object object2, String string, CallContext callContext) {
        StringUtils.tokenize$X(object2, string, "", callContext);
    }

    public static void tokenize$X(Object object2, String string, String string2, CallContext callContext) {
        int n;
        Consumer consumer;
        String string3;
        block2: {
            int n2;
            string3 = StringUtils.coerceToString(object2, "tokenize", 1, "");
            consumer = callContext.consumer;
            Matcher matcher = StringUtils.makePattern(string, string2).matcher(string3);
            int n3 = string3.length();
            if (n3 == 0) {
                return;
            }
            n = 0;
            do {
                boolean bl;
                if (!(bl = matcher.find())) break block2;
                n2 = matcher.start();
                consumer.writeObject(string3.substring(n, n2));
            } while ((n = matcher.end()) != n2);
            throw new IllegalArgumentException("pattern matches empty string");
        }
        consumer.writeObject(string3.substring(n));
    }

    public static Object codepointEqual(Object object2, Object object3) {
        String string = StringUtils.coerceToString(object2, "codepoint-equal", 1, null);
        String string2 = StringUtils.coerceToString(object3, "codepoint-equal", 2, null);
        if (string == null || string2 == null) {
            return Values.empty;
        }
        return string.equals(string2) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object normalizeUnicode(Object object2) {
        return StringUtils.normalizeUnicode(object2, "NFC");
    }

    public static Object normalizeUnicode(Object object2, String string) {
        String string2 = StringUtils.coerceToString(object2, "normalize-unicode", 1, "");
        if ("".equals(string = string.trim().toUpperCase())) {
            return string2;
        }
        throw AbstractSequence.unsupportedException("normalize-unicode form " + string);
    }
}

